(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     49025,       1392]
NotebookOptionsPosition[     46383,       1324]
NotebookOutlinePosition[     46738,       1340]
CellTagsIndexPosition[     46695,       1337]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"V", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "*", "v"}]}], ",", 
     RowBox[{
      RowBox[{"U", "+", 
       RowBox[{"r", "*", "w"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "*", 
       RowBox[{"(", 
        RowBox[{"u", "+", 
         RowBox[{"r", "*", "w"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "r", "*", "W"}], "-", 
       RowBox[{"5", "*", "U"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", "r", "*", "w"}], "-", 
       RowBox[{"5", "*", "u"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"V", ",", "U", ",", "W"}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.672830172829295*^9, 3.672830357786088*^9}, {
   3.672830390271138*^9, 3.672830408572218*^9}, {3.6729915430315323`*^9, 
   3.672991578219675*^9}, 3.672992751366727*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"V", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "v"}], " ", "\[Beta]"}]}], ",", 
    RowBox[{"U", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "r"}], " ", "w"}], "-", 
      RowBox[{"u", " ", "\[Alpha]"}], "-", 
      RowBox[{"r", " ", "w", " ", "\[Alpha]"}]}]}], ",", 
    RowBox[{"W", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"5", " ", "u"}], "+", 
        RowBox[{"3", " ", "r", " ", "w"}], "+", 
        RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
        RowBox[{"5", " ", "r", " ", "w", " ", "\[Alpha]"}]}], 
       RowBox[{"2", " ", "r"}]]}]}]}], "}"}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.67283041245233*^9, 3.672991704691616*^9, {3.672992751366988*^9, 
   3.672992764181279*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "v"}], " ", "\[Beta]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.672831335132305*^9, 3.6728313386559267`*^9}, 
   3.672992751367132*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "v"}], " ", "\[Beta]"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672830508381905*^9, 3.672991720995191*^9, {3.67299275136723*^9, 
   3.672992764311108*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "r"}], " ", "w"}], "-", 
  RowBox[{"u", " ", "\[Alpha]"}], "-", 
  RowBox[{"r", " ", "w", " ", "\[Alpha]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672991718127016*^9, 3.672992751367347*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "r"}], " ", "w"}], "-", 
  RowBox[{"u", " ", "\[Alpha]"}], "-", 
  RowBox[{"r", " ", "w", " ", "\[Alpha]"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672830515305938*^9, 3.672991723260833*^9, {3.672992751367442*^9, 
   3.672992764365446*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"5", " ", "u"}], "+", 
    RowBox[{"3", " ", "r", " ", "w"}], "+", 
    RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
    RowBox[{"5", " ", "r", " ", "w", " ", "\[Alpha]"}]}], 
   RowBox[{"2", " ", "r"}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672991728446666*^9, 3.672992751367564*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"5", " ", "u"}], "+", 
    RowBox[{"3", " ", "r", " ", "w"}], "+", 
    RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
    RowBox[{"5", " ", "r", " ", "w", " ", "\[Alpha]"}]}], 
   RowBox[{"2", " ", "r"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672830521503529*^9, 3.672991730794701*^9, {3.672992751367661*^9, 
   3.672992764415876*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"V", "\[Equal]", 
      RowBox[{"%2", "-", 
       RowBox[{"g", "*", "t"}]}]}], ",", 
     RowBox[{"X", "\[Equal]", 
      RowBox[{"x", "+", 
       RowBox[{"%3", "*", "t"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "d"}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", "*", "%2", "*", "t"}], "-", 
       RowBox[{"g", "*", 
        RowBox[{"t", "^", "2"}]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "X", ",", "V"}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6728304496302423`*^9, 3.672830474509779*^9}, {
   3.672830527145628*^9, 3.672830619704254*^9}, {3.672831427717986*^9, 
   3.67283145972064*^9}, 3.672992751367776*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "v"}], " ", "\[Beta]"}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
          RowBox[{
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{"x", "+", 
       FractionBox[
        RowBox[{"r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], "+", 
       FractionBox[
        RowBox[{"u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], "+", 
       FractionBox[
        RowBox[{"r", " ", "v", " ", "w", " ", "\[Alpha]", " ", "\[Beta]"}], 
        "g"], "+", 
       FractionBox[
        RowBox[{"r", " ", "w", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
       FractionBox[
        RowBox[{"u", " ", "\[Alpha]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
       FractionBox[
        RowBox[{"r", " ", "w", " ", "\[Alpha]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}]}], ",", 
     RowBox[{"V", "\[Rule]", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
        RowBox[{
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["\[Beta]", "2"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "v"}], " ", "\[Beta]"}], "+", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
          RowBox[{
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{"x", "+", 
       FractionBox[
        RowBox[{"r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], "+", 
       FractionBox[
        RowBox[{"u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], "+", 
       FractionBox[
        RowBox[{"r", " ", "v", " ", "w", " ", "\[Alpha]", " ", "\[Beta]"}], 
        "g"], "-", 
       FractionBox[
        RowBox[{"r", " ", "w", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "-", 
       FractionBox[
        RowBox[{"u", " ", "\[Alpha]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "-", 
       FractionBox[
        RowBox[{"r", " ", "w", " ", "\[Alpha]", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
           RowBox[{
            SuperscriptBox["v", "2"], " ", 
            SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}]}], ",", 
     RowBox[{"V", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}]}]}], "}"}]}], "}"}]], "Output",\

 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.6728306239481907`*^9, 3.672831463604059*^9, 3.672991830253496*^9, {
   3.672992751367901*^9, 3.672992764466675*^9}}],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   RowBox[{"r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], "+", 
  FractionBox[
   RowBox[{"u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], "+", 
  FractionBox[
   RowBox[{"r", " ", "v", " ", "w", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], 
  "+", 
  FractionBox[
   RowBox[{"r", " ", "w", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
  FractionBox[
   RowBox[{"u", " ", "\[Alpha]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
  FractionBox[
   RowBox[{"r", " ", "w", " ", "\[Alpha]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672831680943611*^9, 3.672991975675378*^9, 
  3.672992751367997*^9}],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   RowBox[{"r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], "+", 
  FractionBox[
   RowBox[{"u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], "+", 
  FractionBox[
   RowBox[{"r", " ", "v", " ", "w", " ", "\[Alpha]", " ", "\[Beta]"}], "g"], 
  "+", 
  FractionBox[
   RowBox[{"r", " ", "w", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
  FractionBox[
   RowBox[{"u", " ", "\[Alpha]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
  FractionBox[
   RowBox[{"r", " ", "w", " ", "\[Alpha]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
      RowBox[{
       SuperscriptBox["v", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672831523770702*^9, 3.672831683673114*^9, 3.672991978135626*^9, {
   3.6729927513681107`*^9, 3.672992764495479*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    SuperscriptBox["\[Beta]", "2"]}]}]]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672831693893724*^9, 3.672991983701887*^9, 
  3.672992751368496*^9}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
   RowBox[{
    SuperscriptBox["v", "2"], " ", 
    SuperscriptBox["\[Beta]", "2"]}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672831530140452*^9, 3.672831697296074*^9, 3.67299198597323*^9, {
   3.672992751368681*^9, 3.672992764550269*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"V", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Beta]"}], "*", "%7"}]}], ",", 
     RowBox[{
      RowBox[{"U", "-", 
       RowBox[{"r", "*", "W"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "*", 
       RowBox[{"(", 
        RowBox[{"%3", "-", 
         RowBox[{"r", "*", "%4"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "r", "*", "W"}], "+", 
       RowBox[{"5", "*", "U"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", "r", "*", "%4"}], "+", 
       RowBox[{"5", "*", "%3"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"V", ",", "U", ",", "W"}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.672830685722726*^9, 3.672830848727085*^9}, {
   3.672831534755762*^9, 3.672831544127736*^9}, {3.67283160324109*^9, 
   3.672831624163784*^9}, {3.672831701416133*^9, 3.672831701807138*^9}, {
   3.672991998245767*^9, 3.6729920014179287`*^9}, {3.672992154111168*^9, 
   3.672992159609168*^9}, 3.672992751368856*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"V", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "\[Beta]"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
        RowBox[{
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["\[Beta]", "2"]}]}]]}]}], ",", 
    RowBox[{"U", "\[Rule]", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", "u"}], "-", 
        RowBox[{"8", " ", "r", " ", "w"}], "-", 
        RowBox[{"15", " ", "u", " ", "\[Alpha]"}], "-", 
        RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
        RowBox[{"3", " ", "u", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3", " ", "r", " ", "w", " ", 
         SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ",", 
    RowBox[{"W", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"10", " ", "u"}], "+", 
        RowBox[{"16", " ", "r", " ", "w"}], "-", 
        RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
        RowBox[{"15", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
        RowBox[{"15", " ", "u", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"15", " ", "r", " ", "w", " ", 
         SuperscriptBox["\[Alpha]", "2"]}]}], 
       RowBox[{"14", " ", "r"}]]}]}]}], "}"}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672831627431456*^9, 3.672831705639802*^9, 3.672992174247076*^9, {
   3.672992751368972*^9, 3.672992764599036*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[Beta]"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
    RowBox[{
     SuperscriptBox["v", "2"], " ", 
     SuperscriptBox["\[Beta]", "2"]}]}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672992751369053*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[Beta]"}], " ", 
  SqrtBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
    RowBox[{
     SuperscriptBox["v", "2"], " ", 
     SuperscriptBox["\[Beta]", "2"]}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672831733428894*^9, 3.672992182143862*^9, {3.672992751369239*^9, 
   3.672992764650584*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", "u"}], "-", 
    RowBox[{"8", " ", "r", " ", "w"}], "-", 
    RowBox[{"15", " ", "u", " ", "\[Alpha]"}], "-", 
    RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
    RowBox[{"3", " ", "u", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "-", 
    RowBox[{"3", " ", "r", " ", "w", " ", 
     SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.6729921881650667`*^9, 3.6729927513693542`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], " ", "u"}], "-", 
    RowBox[{"8", " ", "r", " ", "w"}], "-", 
    RowBox[{"15", " ", "u", " ", "\[Alpha]"}], "-", 
    RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
    RowBox[{"3", " ", "u", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "-", 
    RowBox[{"3", " ", "r", " ", "w", " ", 
     SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.6728317396514387`*^9, 3.67299219061665*^9, {3.672992751369439*^9, 
   3.672992764699725*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"10", " ", "u"}], "+", 
    RowBox[{"16", " ", "r", " ", "w"}], "-", 
    RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
    RowBox[{"15", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
    RowBox[{"15", " ", "u", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "-", 
    RowBox[{"15", " ", "r", " ", "w", " ", 
     SuperscriptBox["\[Alpha]", "2"]}]}], 
   RowBox[{"14", " ", "r"}]]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.672992195040019*^9, 3.672992751369521*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"10", " ", "u"}], "+", 
    RowBox[{"16", " ", "r", " ", "w"}], "-", 
    RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
    RowBox[{"15", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
    RowBox[{"15", " ", "u", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "-", 
    RowBox[{"15", " ", "r", " ", "w", " ", 
     SuperscriptBox["\[Alpha]", "2"]}]}], 
   RowBox[{"14", " ", "r"}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672831757703278*^9, 3.672992197095818*^9, {3.672992751369602*^9, 
   3.67299276475238*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"V", "\[Equal]", 
      RowBox[{"%9", "-", 
       RowBox[{"g", "*", "t"}]}]}], ",", 
     RowBox[{"X", "\[Equal]", 
      RowBox[{"%6", "+", 
       RowBox[{"%10", "*", "t"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "d"}], "\[Equal]", 
      RowBox[{
       RowBox[{"g", "*", 
        RowBox[{"t", "^", "2"}]}], "-", 
       RowBox[{"2", "*", "%9", "*", "t"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "V", ",", "X"}], "}"}]}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.6728317608656597`*^9, 3.672831868195429*^9}, {
   3.6728319417370777`*^9, 3.672831944314942*^9}, {3.672832001458879*^9, 
   3.6728320388888063`*^9}, {3.672992254706399*^9, 3.672992358900777*^9}, 
   3.672992751369684*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Beta]", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
            RowBox[{
             SuperscriptBox["v", "2"], " ", 
             SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}], "+", 
       FractionBox[
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", "d", " ", "g"}], "-", 
          RowBox[{"2", " ", "d", " ", "g", " ", 
           SuperscriptBox["\[Beta]", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox["\[Beta]", "4"]}]}]], "g"]}]}], ",", 
     RowBox[{"V", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{
       FractionBox["1", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "x"}], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], 
         "+", 
         FractionBox[
          RowBox[{"7", " ", "u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], 
          "g"], "+", 
         FractionBox[
          RowBox[{
          "7", " ", "r", " ", "v", " ", "w", " ", "\[Alpha]", " ", 
           "\[Beta]"}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "w", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "u", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"5", " ", "u", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"8", " ", "r", " ", "w", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{
          "11", " ", "r", " ", "w", " ", "\[Alpha]", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "u", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "r", " ", "w", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"5", " ", "u", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"8", " ", "r", " ", "w", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"3", " ", "u", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
         FractionBox[
          RowBox[{"3", " ", "r", " ", "w", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Beta]", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
            RowBox[{
             SuperscriptBox["v", "2"], " ", 
             SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"]}], "-", 
       FractionBox[
        SqrtBox[
         RowBox[{
          RowBox[{"2", " ", "d", " ", "g"}], "-", 
          RowBox[{"2", " ", "d", " ", "g", " ", 
           SuperscriptBox["\[Beta]", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["v", "2"], " ", 
           SuperscriptBox["\[Beta]", "4"]}]}]], "g"]}]}], ",", 
     RowBox[{"V", "\[Rule]", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "d", " ", "g"}], "-", 
        RowBox[{"2", " ", "d", " ", "g", " ", 
         SuperscriptBox["\[Beta]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["v", "2"], " ", 
         SuperscriptBox["\[Beta]", "4"]}]}]]}], ",", 
     RowBox[{"X", "\[Rule]", 
      RowBox[{
       FractionBox["1", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "x"}], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], 
         "+", 
         FractionBox[
          RowBox[{"7", " ", "u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], 
          "g"], "+", 
         FractionBox[
          RowBox[{
          "7", " ", "r", " ", "v", " ", "w", " ", "\[Alpha]", " ", 
           "\[Beta]"}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "w", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "u", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"7", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"5", " ", "u", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"8", " ", "r", " ", "w", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{
          "11", " ", "r", " ", "w", " ", "\[Alpha]", " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "u", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "r", " ", "w", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"5", " ", "u", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"8", " ", "r", " ", "w", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "u", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "+", 
         FractionBox[
          RowBox[{"3", " ", "r", " ", "w", " ", 
           SuperscriptBox["\[Alpha]", "2"], " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"2", " ", "d", " ", "g"}], "-", 
             RowBox[{"2", " ", "d", " ", "g", " ", 
              SuperscriptBox["\[Beta]", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["v", "2"], " ", 
              SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"]}], ")"}]}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.672832053802355*^9, 3.672992366145857*^9, {3.672992751369767*^9, 
   3.6729927648627367`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"V", "[", 
   RowBox[{
   "u_", ",", "v_", ",", "w_", ",", "x_", ",", "d_", ",", "r_", ",", 
    "\[Alpha]_", ",", "\[Beta]_", ",", "g_"}], "]"}], ":=", 
  RowBox[{"-", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", " ", "d", " ", "g"}], "-", 
     RowBox[{"2", " ", "d", " ", "g", " ", 
      SuperscriptBox["\[Beta]", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["v", "2"], " ", 
      SuperscriptBox["\[Beta]", "4"]}]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "[", 
   RowBox[{
   "u_", ",", "v_", ",", "w_", ",", "x_", ",", "d_", ",", "r_", ",", 
    "\[Alpha]_", ",", "\[Beta]_", ",", "g_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"7", " ", "x"}], "+", 
     FractionBox[
      RowBox[{"7", " ", "r", " ", "v", " ", "w", " ", "\[Beta]"}], "g"], "+", 
     
     FractionBox[
      RowBox[{"7", " ", "u", " ", "v", " ", "\[Alpha]", " ", "\[Beta]"}], 
      "g"], "+", 
     FractionBox[
      RowBox[{
      "7", " ", "r", " ", "v", " ", "w", " ", "\[Alpha]", " ", "\[Beta]"}], 
      "g"], "+", 
     FractionBox[
      RowBox[{"7", " ", "r", " ", "w", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"7", " ", "u", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"7", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"5", " ", "u", " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"8", " ", "r", " ", "w", " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{
      "11", " ", "r", " ", "w", " ", "\[Alpha]", " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"3", " ", "u", " ", 
       SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "+", 
     FractionBox[
      RowBox[{"3", " ", "r", " ", "w", " ", 
       SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "d", " ", "g"}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "2"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"5", " ", "u", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"8", " ", "r", " ", "w", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"15", " ", "u", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"3", " ", "u", " ", 
       SuperscriptBox["\[Alpha]", "2"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"], "-", 
     FractionBox[
      RowBox[{"3", " ", "r", " ", "w", " ", 
       SuperscriptBox["\[Alpha]", "2"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "d", " ", "g"}], "-", 
         RowBox[{"2", " ", "d", " ", "g", " ", 
          SuperscriptBox["\[Beta]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["v", "2"], " ", 
          SuperscriptBox["\[Beta]", "4"]}]}]]}], "g"]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"W", "[", 
   RowBox[{
   "u_", ",", "v_", ",", "w_", ",", "x_", ",", "d_", ",", "r_", ",", 
    "\[Alpha]_", ",", "\[Beta]_", ",", "g_"}], "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"10", " ", "u"}], "+", 
     RowBox[{"16", " ", "r", " ", "w"}], "-", 
     RowBox[{"5", " ", "u", " ", "\[Alpha]"}], "+", 
     RowBox[{"15", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
     RowBox[{"15", " ", "u", " ", 
      SuperscriptBox["\[Alpha]", "2"]}], "-", 
     RowBox[{"15", " ", "r", " ", "w", " ", 
      SuperscriptBox["\[Alpha]", "2"]}]}], 
    RowBox[{"14", " ", "r"}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{
   "u_", ",", "v_", ",", "w_", ",", "x_", ",", "d_", ",", "r_", ",", 
    "\[Alpha]_", ",", "\[Beta]_", ",", "g_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", "u"}], "-", 
     RowBox[{"8", " ", "r", " ", "w"}], "-", 
     RowBox[{"15", " ", "u", " ", "\[Alpha]"}], "-", 
     RowBox[{"11", " ", "r", " ", "w", " ", "\[Alpha]"}], "-", 
     RowBox[{"3", " ", "u", " ", 
      SuperscriptBox["\[Alpha]", "2"]}], "-", 
     RowBox[{"3", " ", "r", " ", "w", " ", 
      SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.672992522107369*^9, 3.6729925828137217`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RecurrenceTable", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"u", "[", "n", "]"}], ",", 
        RowBox[{"v", "[", "n", "]"}], ",", 
        RowBox[{"w", "[", "n", "]"}], ",", 
        RowBox[{"x", "[", "n", "]"}], ",", "0.15", ",", "0.0212", ",", "0.5", 
        ",", "0.9", ",", "9.8"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"v", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"V", "[", 
       RowBox[{
        RowBox[{"u", "[", "n", "]"}], ",", 
        RowBox[{"v", "[", "n", "]"}], ",", 
        RowBox[{"w", "[", "n", "]"}], ",", 
        RowBox[{"x", "[", "n", "]"}], ",", "0.15", ",", "0.0212", ",", "0.5", 
        ",", "0.9", ",", "9.8"}], "]"}]}], " ", "\n", "    ", ",", 
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"W", "[", 
       RowBox[{
        RowBox[{"u", "[", "n", "]"}], ",", 
        RowBox[{"v", "[", "n", "]"}], ",", 
        RowBox[{"w", "[", "n", "]"}], ",", 
        RowBox[{"x", "[", "n", "]"}], ",", "0.15", ",", "0.0212", ",", "0.5", 
        ",", "0.9", ",", "9.8"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"X", "[", 
       RowBox[{
        RowBox[{"u", "[", "n", "]"}], ",", 
        RowBox[{"v", "[", "n", "]"}], ",", 
        RowBox[{"w", "[", "n", "]"}], ",", 
        RowBox[{"x", "[", "n", "]"}], ",", "0.15", ",", "0.0212", ",", "0.5", 
        ",", "0.9", ",", "9.8"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{"v", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"-", "7"}]}], ",", 
     RowBox[{
      RowBox[{"w", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672992857389086*^9, 3.672992989118113*^9}, {
   3.672993530376801*^9, 3.672993530479048*^9}, {3.6729935853928213`*^9, 
   3.6729935874156437`*^9}, {3.672994355406904*^9, 3.672994394092498*^9}, {
   3.672994432331306*^9, 3.6729944388115807`*^9}, {3.672995032330533*^9, 
   3.672995039701521*^9}, 3.672995335523329*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.`", ",", 
     RowBox[{"-", "7.`"}], ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.678571428571428`"}], ",", 
     RowBox[{"-", "5.719047123428868`"}], ",", 
     RowBox[{"-", "37.90431266846361`"}], ",", 
     RowBox[{"-", "0.1888461258808043`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12.38456632653061`", ",", 
     RowBox[{"-", "4.692333188297694`"}], ",", "125.21960435117443`", ",", 
     "0.3425669220448097`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "28.84633518586005`"}], ",", 
     RowBox[{"-", "3.873577639737586`"}], ",", 
     RowBox[{"-", "333.1252428110732`"}], ",", 
     RowBox[{"-", "1.212959628356501`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68.9787252951244`", ",", 
     RowBox[{"-", "3.225386877253381`"}], ",", "834.4113750403353`", ",", 
     "3.411502066418544`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "166.57768379429768`"}], ",", 
     RowBox[{"-", "2.717367727281579`"}], ",", 
     RowBox[{"-", "2048.6464372847204`"}], ",", 
     RowBox[{"-", "10.434923290215295`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"403.72148556830837`", ",", 
     RowBox[{"-", "2.3244998860732604`"}], ",", "4994.725665497739`", ",", 
     "31.29761244441108`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.672992993462883*^9, 3.6729930066120453`*^9}, 
   3.672993534153685*^9, 3.672993590745007*^9, {3.672994368669763*^9, 
   3.672994396725588*^9}, 3.672994435697793*^9, 3.6729950426211443`*^9, 
   3.6729953397575893`*^9}]
}, Open  ]]
},
WindowSize->{Full, Full},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"10.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 23, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 972, 28, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[1555, 52, 879, 25, 47, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[2437, 79, 220, 5, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[2660, 86, 243, 6, 28, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[2906, 94, 288, 7, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3197, 103, 342, 9, 28, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3542, 114, 404, 10, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3949, 126, 458, 12, 47, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4410, 140, 797, 22, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5210, 164, 4182, 124, 113, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[9395, 290, 1243, 38, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10641, 330, 1296, 39, 60, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[11940, 371, 339, 10, 41, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[12282, 383, 389, 11, 40, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[12674, 396, 1122, 30, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[13799, 428, 1640, 44, 49, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15442, 474, 345, 11, 41, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15790, 487, 421, 13, 40, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[16214, 502, 603, 15, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[16820, 519, 654, 17, 47, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[17477, 538, 578, 14, 50, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[18058, 554, 631, 16, 49, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[18692, 572, 854, 23, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[19549, 597, 14969, 397, 413, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[34533, 997, 7676, 217, 320, "Input"],
Cell[CellGroupData[{
Cell[42234, 1218, 2507, 62, 63, "Input"],
Cell[44744, 1282, 1623, 39, 46, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
