option = {
    series: [{
        type: 'gauge',
        startAngle: 90,
        endAngle: -270,
        pointer: {
            show: false,
        },
        progress: {
            show: true,
            overlap: false,
            roundCap: true,
            clip: false,
            itemStyle: {
                borderWidth: 1,
                borderColor: '#464646'
            }
        },
        axisLine: {

            lineStyle: {
                width: 20
            }
        },
        splitLine: {
            show: false,
            distance: 0,
            length: 10
        },
        axisTick: {
            show: false
        },
        axisLabel: {
            show: false,
            distance: 50
        },
        data: [{
            value: 20,
            title: {
                offsetCenter: ['0%', '-30%']
            },
            detail: {
                offsetCenter: ['0%', '-5%']
            },
            itemStyle: {
                color: 'blue',
            },
        },],
        title: {
            fontSize: 14
        },
        detail: {
            fontSize: 120,
            fontWeight: 'bolder',
            color: 'black',
            borderColor: 'black',
        },
        animation: false,
    }]
};

const clock = document.getElementById('clock');
const myChart = echarts.init(clock);
let state = false;
let originNow = Date.now();
let jump = false;
let jumps = 0;
let time = 1;
let minute = Math.floor(time);
let second = Math.floor((time - minute) * 60);
let startButton = document.getElementById('start');

startButton.onclick = function () {
    state = !state;
    startButton.innerText = state ? '暂停' : '继续';
}

function setTime(min) {
    state = false;
    time = min;
    minute = Math.floor(time);
    second = Math.floor((time - minute) * 60);
    startButton.innerText = '开始';
    startButton.disabled = false;
}

function drawClock() {
    let strMinute;
    let strSecond;
    option.series[0].data[0].value = 100 - ((second / 60 + minute) / time * 100);
    strMinute = minute < 10 ? '0' + minute : '' + minute;
    strSecond = second < 10 ? '0' + second : '' + second;
    option.series[0].detail.formatter = strMinute + ':' + strSecond + '';
    if (option.series[0].data[0].value <= 50) {
        option.series[0].data[0].itemStyle.color = 'blue';
    } else if (option.series[0].data[0].value > 90) {
        option.series[0].data[0].itemStyle.color = 'red';
    } else {
        option.series[0].data[0].itemStyle.color = 'orange';
    }
    myChart.setOption(option, true);
}

function run() {
    requestAnimationFrame(run);
    drawClock()
    if (Date.now() - originNow > jumps * 1000) {
        jump = true;
        jumps += 1;
    } else {
        jump = false;
    }
    if (state && jump) {
        if (second > 0) {
            second -= 1;
        } else {
            if (minute === 0) {
                state = false;
                startButton.innerText = '开始';
                startButton.disabled = true;
            } else {
                minute -= 1;
                second = 59;
            }
        }
    }
}

run()
